/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Single Point D/A
/* - Contents: α׷ COMILX_DA_Out(...)Լ Ͽ 
/*     Single point D/A ϴ α׷Դϴ.
/*
/* - Remarks : 
/*     1.   COMI-LX101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMILX_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ComidasLX.h"

#define DEV_ID	COMI_LX101
#define CHAN	 0
#define VMIN	-5 
#define VMAX	 5

void main (void)
{
	HANDLE hDevice;

	if(!COMILX_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	hDevice = COMILX_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMILX_UnloadDll();
		exit(0);
	}

	printf("D/A  Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();

	while(!kbhit())
	{
		printf("D/A Out 5 volt !\n");
		COMILX_DA_Out (hDevice, 0, 5.f); /* D/A CH0  5 volt . */
		Sleep(1000); /* 1 sec delay */
		printf("D/A Out 0 volt !\n");
		COMILX_DA_Out (hDevice, 0, 0.f); /* D/A CH0  0 volt . */
		Sleep(1000); /* 1 sec delay */
	}
	
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}
